/*  Übernimmt bestehende Terminierungen aus der Tabelle "ab2_wkstplan".

    Dafür werden alle offenen AGe der Reihe sortiert nach a2w_planweek, a2w_prio einzeln einterminiert.

    Über den Parameter _timeframe kann man auch nur die bestehende Terminierung von AGen aus einem bestimmten Zeitfenster
    übernehmen. Wird im Mirgrationsskript verwendet um die Übernahme der bestehenden Terminierungen in kleinere Transaktionen
    aufzuteilen.

    Passt der Start eines AGs nicht mehr in die Planwoche wird er eine Sekunde vor dem Arbeitsende der Planwoche der jeweiligen
    Ressource über DLZ-Terminierung terminiert.

    Das Ressourcennetzwerk muss in dieser Funktion nicht mehr eingeschränkt werden. Im Migrationsskript wird die bei der
    ursprünglichen Terminierung verwendete Hauptressource pro AG als Vorgabe für zukünftige Terminierungen des AG in der Spalte
    ab2_wkstplan.a2w_resource_id_main_fix eintragen.*/


/*Einzelne ABK wiederherstellen

UPDATE ab2 SET a2_ende = false WHERE a2_ab_ix IN (235725, 236175, 236176, 236429, 236888);

-- SELECT scheduling.ab2__resource_requirements_options__ksvba__from__ab2__create( ab2 ) FROM ab2 WHERE a2_ab_ix IN (235724);#

SELECT scheduling.ab2_wkstplan__resource_id_main_fix__move__set(a2_id, scheduling.resource__translate__ksvba__shorthand__to__resource_id( a2w_ks ) , _all_ag_withthis_resource => false ) FROM ab2, ab2_wkstplan WHERE a2w_a2_id = a2_id AND a2_ab_ix IN (235725, 236175, 236176, 236429, 236888);

SELECT scheduling.resource_timeline__migrate_from_ab2_wkstplan( _limit_a2_id => a2_id) FROM ab2 WHERE a2_ab_ix IN (235725, 236175, 236176, 236429, 236888);

-- SELECT a2_n, a2_ende, a2_at, a2_et, rt.*, a2w_ks, a2w_resource_id_main_terminated, a2w_resource_id_main_fix FROM ab2 LEFT JOIN scheduling.resource_timeline rt ON ti_a2_id = a2_id LEFT JOIN ab2_wkstplan ON a2w_a2_id = a2_id WHERE a2_ab_ix = 235724 ORDER BY a2_n

*/
SELECT tsystem.function__drop_by_regex( 'resource_timeline__migrate_from_ab2_wkstplan', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.resource_timeline__migrate_from_ab2_wkstplan(
      _obey_min_startDate bool = false    -- Bewirkt, dass Arbeitsgänge nur in der Zukunft, also nicht in der Vergangenheit einterminiert werden dürfen.
    , _limit_to_ksv varchar DEFAULT null  -- Nur die Arbeitsgägnge der angebenen Kostenstelle migrieren.
    , _timeframe varchar DEFAULT null     -- Legt das Zeitfenster fest innerhalb der die  bestehenden Terminierungen aus der Tabelle "ab2_wkstplan" übernommen werden sollen.
                                          -- Möglich sind:  + null        - Gesamter Zeitraum (Standard).
                                          --                + '2weeks'    - Vergangenheit bis einschließlich zwei Wochen in der Zukunft.
                                          --                + '4weeks'    - Vergangenheit bis einschließlich vier Wochen in der Zukunft.
                                          --                + 'halfyear'  - Von fünf Wochen in Zukunft bis halbes Jahr in der Zukunft.
                                          --                + 'remaining' - Übriger Zeitraum ab dem halben Jahr in der Zukunft.
    , _limit_a2_id integer DEFAULT null
) RETURNS void AS $$

  DECLARE

    _prefix varchar := 'scheduling.resource_timeline__migrate_from_ab2_wkstplan -';
    _count integer;
    _totalcount integer;
    _ab_record record;
    _ab2 ab2;
    _conflicted scheduling.resource_timeline_blockstatus;
    _timeframe_start timestamp;
    _timeframe_end timestamp;
    _work_end_of_week timestamp;
    _ks_sperr bool;
    _time_required numeric(16,6);
    _checkBlockedTimes bool;
    _loglevel integer := TSystem.Log_Get_LogLevel( _user => 'yes' );

    -- Messung Dauer für die Schleifendurchläufe
    _loop_time_begin    timestamp;
    _loop_time_end      timestamp;
    _loop_time_current  interval;
    _loop_time_min      interval;
    _loop_time_max      interval;
    _loop_time_avg      interval;
    _loop_time_total    interval;

    -- Exception-Handling
    _errmsg text;
    _message_text text;
    _pg_exception_context text;
    _pg_exception_detail text;
    _pg_exception_hint text;


    -- timeslot_record record;
    -- _hours numeric(16,6);
    -- _bench_start BIGINT;
    -- _timeslot_record_conflicted record;
    -- _ks_dlz int;
    -- _lastNonconflictedEndeDate timestamp;

  BEGIN
    PERFORM disablebedarfberech();

    _count := 0;
    _totalcount :=  count( * )
                        FROM ab2
                        JOIN ab2_wkstplan ON a2w_a2_id = a2_id AND a2w_marked >= 0
                        JOIN ksv ON ks_abt = a2_ks
                        JOIN abk ON a2_ab_ix = ab_ix
                        WHERE   a2w_planweek IS NOT null
                            AND a2_interm
                            AND NOT a2_ende
                            AND NOT ab_done
                            AND ab_inplantaf
                            AND NOT ks_sperr
                            AND ks_plan                -- AG auf planungsrelevanter Kostenstelle, also kein Info-AG
                            AND a2w_ks NOT LIKE '% |0' -- keine AGe von Pool-Kostenstellen übernehmen
                            AND CASE
                                    WHEN ( _limit_to_ksv IS NOT null ) THEN a2w_ks ~~* (_limit_to_ksv || '%') -- ~~* Regexp-Operator entspricht "ILIKE"
                                    ELSE true
                                END
                            AND CASE
                                    WHEN _timeframe IS null       THEN true
                                    WHEN _timeframe = '2weeks'    THEN a2w_planweek <= termweek( now()::timestamp + interval '2 weeks' )
                                    WHEN _timeframe = '4weeks'    THEN a2w_planweek > termweek( now()::timestamp + interval '2 weeks' ) AND a2w_planweek <= termweek( now()::timestamp + interval '4 weeks' )
                                    WHEN _timeframe = 'halfyear'  THEN a2w_planweek > termweek( now()::timestamp + interval '4 weeks' ) AND a2w_planweek <= termweek( now()::timestamp + interval '6 month' )
                                    WHEN _timeframe = 'remaining' THEN a2w_planweek > termweek( now()::timestamp + interval '6 month' )
                                    ELSE false
                                END
                            AND CASE WHEN _limit_a2_id IS null
                                     THEN true
                                     ELSE a2_id = _limit_a2_id
                                END
                    ;
    FOR _ab_record IN
        SELECT ab_ix, a2_id, a2_n, a2w_oks, a2w_ks, a2_ks, a2_ksap, a2w_resource_id_main_fix, a2_id, a2w_planweek, a2_ta, a2_time_stemp, a2w_stukorr, a2_ausw, a2_dlz
        FROM ab2
        JOIN ab2_wkstplan ON a2w_a2_id = a2_id AND a2w_marked >= 0
        JOIN ksv ON ks_abt = a2_ks
        JOIN abk ON a2_ab_ix = ab_ix
        WHERE   a2w_planweek IS NOT null
            AND a2_interm
            AND NOT a2_ende
            AND NOT ab_done
            AND ab_inplantaf
            AND NOT ks_sperr
            AND ks_plan                -- AG auf planungsrelevanter Kostenstelle, also kein Info-AG
            AND a2w_ks NOT LIKE '% |0' -- keine AGe von Pool-Kostenstellen übernehmen
            AND CASE
                    WHEN ( _limit_to_ksv IS NOT null ) THEN a2w_ks ~~* (_limit_to_ksv || '%') -- ~~* Regexp-Operator entspricht "ILIKE"
                    ELSE true
                END
            AND CASE
                    WHEN _timeframe IS null       THEN true
                    WHEN _timeframe = '2weeks'    THEN a2w_planweek <= termweek( now()::timestamp + interval '2 weeks' )
                    WHEN _timeframe = '4weeks'    THEN a2w_planweek > termweek( now()::timestamp + interval '2 weeks' ) AND a2w_planweek <= termweek( now()::timestamp + interval '4 weeks' )
                    WHEN _timeframe = 'halfyear'  THEN a2w_planweek > termweek( now()::timestamp + interval '4 weeks' ) AND a2w_planweek <= termweek( now()::timestamp + interval '6 month' )
                    WHEN _timeframe = 'remaining' THEN a2w_planweek > termweek( now()::timestamp + interval '6 month' )
                    ELSE false
                END
            AND CASE WHEN _limit_a2_id IS null
                     THEN true
                     ELSE a2_id = _limit_a2_id
                END

        ORDER BY
              a2w_planweek ASC,
              a2w_prio ASC,
              a2_at ASC,
              a2_id ASC
    LOOP

      _count := _count + 1;
      _loop_time_begin := clock_timestamp();
      _conflicted := null;
      _checkBlockedTimes := true;   -- Standard: keine DLZ.

      -- Debug
      IF _loglevel >= 4 THEN
          RAISE NOTICE '% [% / %] start ab2 id: %, kw:%,  ks_shorthand:%;', _prefix, _count, _totalcount, _ab_record.a2_id, _ab_record.a2w_planweek, _ab_record.a2w_ks;
      END IF;

      -- Zeitgrenzen für Terminierung des aktuellen AG bestimmen.
      _timeframe_start := to_timestamp( _ab_record.a2w_planweek, 'IYYYIW' )::timestamp;
      IF ( _obey_min_startDate AND _timeframe_start < now()::timestamp ) THEN
          _timeframe_start = now()::timestamp;
      END IF;
      -- Wir sind in der aktuellen Woche, dann Terminiere beginnend von heute, anstatt beginnend von Montag.
      IF ( _ab_record.a2w_planweek = termweek( now()::timestamp ) ) THEN
          -- Debug; Aktuelle Woche
          IF _loglevel >= 5 THEN
              RAISE NOTICE '% terminate [ab2 %] from today, because we are in current planweek, a2w_planweek:% = current week:%',
                  _prefix,
                  _ab_record.a2_id,_ab_record.a2w_planweek, termweek( now()::timestamp );
          END IF;
          _timeframe_start = now()::timestamp;
      END IF;
      _timeframe_end := _timeframe_start + interval '1 year';

      -- Ermitteln, ob zu verwendende Kostenstelle gesperrt ist.
      -- TODO AXS: Was ist zu tun bei Poolkostenstellen? AG sperren oder auf Arbeitsplatz 1 umlenken? Aktuell ist Umlenkung auf AP 1 implementiert.
      _ks_sperr := ks_sperr FROM ksv WHERE ks_id = (scheduling.resource__translate__resource_id__to__ksvba__shorthand( _ab_record.a2w_resource_id_main_fix )).ksb_ks_id;

      -- Prüfung, ob KSV existiert.
      IF ( _ks_sperr IS null ) THEN
          IF _loglevel >= 4 THEN
                RAISE NOTICE '% skip [ab2: %] due to ks_sperr = null -> ksv non-existing (%)', _prefix, _ab_record.a2_id, _ab_record.a2w_ks;
          END IF;
          CONTINUE;
      END IF;

      -- Prüfung, ob KSV gesperrt.
      IF ( _ks_sperr ) THEN
          IF _loglevel >= 4 THEN
              RAISE NOTICE '% skip [ab2: %] due to ks_sperr', _prefix, _ab_record.a2_id;
          END IF;
          CONTINUE;
      END IF;

      -- Prüfung, ob überhaupt noch notwendige Arbeitszeit vorhanden ist.
      -- Dabei aber Bedarfs-AGe zulassen. Diese haben eine Laufzeit von 0 (a2_ta).
      _time_required := scheduling.ab2__required_worktime__get( _ab_record.a2_id );
      IF ( ( _time_required = 0 OR _time_required IS null ) AND ( _ab_record.a2_ta > 0 ) ) THEN
          IF _loglevel >= 4 THEN
              RAISE NOTICE '% skip [ab2: %] due to time required = 0', _prefix, _ab_record.a2_id;
          END IF;
          CONTINUE;
      END IF;

      -- Prüfung, ob AG schon einterminiert ist.
      IF EXISTS ( SELECT * FROM scheduling.resource_timeline WHERE ti_a2_id = _ab_record.a2_id ) THEN
          IF _loglevel >= 4 THEN
              RAISE NOTICE '% skip [ab2: %] due already in timeline', _prefix, _ab_record.a2_id;
          END IF;
          CONTINUE;
      END IF;

      -- Exception-Handling-Block um eventuelle Fehler bei der Terminierung des aktuellen AG abzufangen und danach weiterarbeiten zu können.
      BEGIN

          -- Versuche aktuellen AG normal einzuterminieren.
          IF _loglevel >= 4 THEN
              RAISE NOTICE '% call: scheduling.resource_timeline__abk_ab2__termination( _abk_ix => %, _timeframe_start => %, _timeframe_end => %, _write_to_disk => %, _termination_range_ab2_id_start => %, _termination_range_ab2_id_end => %, _loglevel => % )',
                  _prefix,
                  _ab_record.ab_ix, _timeframe_start, _timeframe_end, true, _ab_record.a2_id, _ab_record.a2_id,
                  _loglevel
              ;
          END IF;
          PERFORM scheduling.resource_timeline__abk_ab2__termination(
              _abk_ix                         => _ab_record.ab_ix
            , _timeframe_start                => _timeframe_start
            , _timeframe_end                  => _timeframe_end
            , _write_to_disk                  => true
            , _checkBlockedTimes              => _checkBlockedTimes   -- Wir wollen hier KEINE DLZ-Terminierung, außer es handelt sich um eine Auswärtskostenstelle.
            , _termination_range_ab2_id_start => _ab_record.a2_id
            , _termination_range_ab2_id_end   => _ab_record.a2_id
            , _allow_overlap                  => true                 -- Auch schon beim ersten Terminierungsversuch Überlappungen bei der Terminierung von Arbeitsgängen innerhalb der gleichen ABK erlauben.
            , _loglevel                       => _loglevel
          );

          -- Prüfe, ob der erste Task-Eintrag der Terminierung noch in der Planwoche startet.
          IF EXISTS ( SELECT min( ti_date_start ) FROM scheduling.resource_timeline WHERE ti_a2_id = _ab_record.a2_id GROUP BY ti_a2_id HAVING min( ti_date_start ) >= to_timestamp( _ab_record.a2w_planweek, 'IYYYIW' )::timestamp + interval  '1 week' ) THEN
              --  Debug: DLZ
              IF _loglevel >= 4 THEN
                  RAISE NOTICE '% terminate [ab2 %] with DLZ, due not starting in planweek % (% - %)',
                      _prefix,
                      _ab_record.a2_id, _ab_record.a2w_planweek, _timeframe_start, _timeframe_start + interval '1 week' - interval '1 second'
                  ;
              END IF;
              -- Terminiere vorherige normale Terminierung wieder aus.
              DELETE FROM scheduling.resource_timeline
              WHERE ti_a2_id = _ab_record.a2_id;
              -- Arbeitsende der aktuellen Planwoche ermitteln:
              -- + Ende der letzten Lücke in der aktuellen Planwoche nehmen.
              -- + Konnte keine Lücke gefunden werden, den Anfang der nächsten Planwoche annehmen.
              _work_end_of_week := coalesce( max( slotenddate ), to_timestamp( _ab_record.a2w_planweek, 'IYYYIW' )::timestamp + interval  '1 week' )
                              FROM scheduling.resource_timeline__timeslots__search(
                                        _resource_id        => _ab_record.a2w_resource_id_main_fix,
                                        _time_required      => 1,
                                        _load_required      => 1,
                                        _timeframe_start    => to_timestamp( _ab_record.a2w_planweek, 'IYYYIW' )::timestamp,
                                        _timeframe_end      => to_timestamp( _ab_record.a2w_planweek, 'IYYYIW' )::timestamp + interval  '1 week' - interval '1 second',
                                        _direction          => 'backward',
                                        _checkBlockedTimes  => false,
                                        _loglevel           => _loglevel
                                    );
              --  Debug: Arbeitsende der Woche
              IF _loglevel >= 5 THEN
                  RAISE NOTICE '% [ab2: %] work_end_of_week of planweek % (% - %): %',
                      _prefix,
                      _ab_record.a2_id, _ab_record.a2w_planweek, _timeframe_start, _timeframe_start + interval '1 week' - interval '1 second', _work_end_of_week
                  ;
              END IF;
              -- Zeitgrenzen ans Arbeitsende der Woche schieben. Aber nicht wenn Option _obey_min_startDate gesetzt ist und das Startdatum durch das Verschieben in der Vergangenheit liegen würde.
              IF ( ( NOT _obey_min_startDate ) OR ( _work_end_of_week >= _timeframe_start ) ) THEN
                  _timeframe_start  := _work_end_of_week - interval '1 second';
                  _timeframe_end    := _timeframe_start + interval '1 year';
              END IF;
              -- Terminiere aktuellen AG über DLZ (am Ende der Woche) ein. Andere Task-Blöche werden dabei nicht beachtet.
              IF _loglevel >= 4 THEN
                  RAISE NOTICE '% call: scheduling.resource_timeline__abk_ab2__termination( _abk_ix => %, _timeframe_start => %, _timeframe_end => %, _write_to_disk => %, _checkBlockedTimes => %, _termination_range_ab2_id_start => %, _termination_range_ab2_id_end => %, _loglevel => % )',
                      _prefix,
                      _ab_record.ab_ix, _timeframe_start, _timeframe_end, true, false, _ab_record.a2_id, _ab_record.a2_id,
                      _loglevel
                  ;
              END IF;
              PERFORM scheduling.resource_timeline__abk_ab2__termination(
                  _abk_ix                         => _ab_record.ab_ix
                , _timeframe_start                => _timeframe_start
                , _timeframe_end                  => _timeframe_end
                , _write_to_disk                  => true
                , _checkBlockedTimes              => false                -- Wir wollen hier DLZ-Terminierung.
                , _termination_range_ab2_id_start => _ab_record.a2_id
                , _termination_range_ab2_id_end   => _ab_record.a2_id
                , _allow_overlap                  => true                 -- Überlappungen bei der Terminierung von Arbeitsgängen innerhalb der gleichen ABK erlauben.
                , _loglevel                       => _loglevel
              );
          END IF;

      EXCEPTION
          WHEN OTHERS THEN
              GET STACKED DIAGNOSTICS _message_text = MESSAGE_TEXT
                                    , _pg_exception_detail = PG_EXCEPTION_DETAIL
                                    , _pg_exception_hint = PG_EXCEPTION_HINT
                                    , _pg_exception_context = PG_EXCEPTION_CONTEXT;
              _errmsg :=  'ERROR: ' || _message_text || E'\n' ||
                          'Detail:' || _pg_exception_detail || E'\n' ||
                          'Context:' || _pg_exception_context || E'\n' ||
                          'Hint:' || _pg_exception_hint || E'\n';
              RAISE WARNING '%', _errmsg;
      END;

      -- Messung Dauer für die Schleifendurchläufe
      _loop_time_end := clock_timestamp();
      _loop_time_current := ( _loop_time_end - _loop_time_begin );
      -- Min
      IF _loop_time_min IS null OR _loop_time_min > _loop_time_current  THEN
          _loop_time_min := _loop_time_current;
      END IF;
      -- Max
      IF _loop_time_max IS null OR _loop_time_max < _loop_time_current THEN
          _loop_time_max := _loop_time_current;
      END IF;
      -- Total
      IF _loop_time_total IS null THEN
          _loop_time_total := _loop_time_current;
      ELSE
          _loop_time_total := _loop_time_total + _loop_time_current;
      END IF;
      -- Debug: Duration
      IF _loglevel >= 5 THEN
          RAISE NOTICE '% duration of [ab2: %] : %',
              _prefix,
              _ab_record.ab_ix, _loop_time_current;
          -- Debug: Duration Statistics
          RAISE NOTICE '% duration statistics : min:%, avg:%, max:%;',
              _prefix,
              _loop_time_min, ( _loop_time_total / _count ), _loop_time_max;
      END IF;

    END LOOP;

    PERFORM enablebedarfberech();

  END $$ LANGUAGE plpgsql;